################################################################################
#
#  kPerl Core Library Group
#  Abstract Object Library - Hash Architecture
#
#  copyright (c)
#  Karol Szafranski on behalf of IMB Jena, Genome Analysis, 1999-2002,2004
#  szafrans@imb-jena.de
#
################################################################################
#
#  DESCRIPTION
#
# - individual description of functions at the beginning of the code blocks
#
################################################################################
#
#  FUNCTIONS, DATA
#
#   @ISA
#
# - housekeeping
#   &new
#   &_LocalSwitch
#
################################################################################

package MainLib::DefaultObjHash;

# includes
use strict; use warnings;
use MainLib::DefaultObj;

# inheritance
our @ISA;
push @ISA, qw(MainLib::DefaultObj);


################################################################################
# housekeeping
################################################################################


# new class instance
#
# INTERFACE
# - argument 0:  class label or object reference
# - argument 1*: initialisation arguments
# - return val:  reference on object
#
# DESCRIPTION
# - this method new() will call method ini(), provided by the derived class.
#   See class method ini() for detailed description of initialisation parameter
#   convention.
#
sub new {
  my $this = {};
  my ($class,@arg) = @_;
  # this syntax works also for the derived classes, whereas `bless $this;' wouldn't
  bless ($this, ref($class)||$class);
  return $this->ini(@arg);
}


# derive local switches from object switches and function switches
#
# INTERFACE
# - argument 1*: hash representing local switch assignments
#
sub _LocalSwitch {
  my ($this, %opt) = @_;

  # load object switches, override with function switches
  my %switch = %{$this->{switch}||{}};
  while (my($key,$val) = each(%opt)) {
    if (defined $val) { $switch{$key} = $val; }
    else              { delete $switch{$key}; }
  }

  # exit SUB
  return %switch;
}


1;
# $Id: DefaultObjHash.pm,v 1.10 2004/11/17 03:34:11 karol Exp $
