################################################################################
#
#  kPerl Core Library Group
#  Abstract Object Library - Array Architecture
#
#  copyright (c)
#  Karol Szafranski on behalf of IMB Jena, Genome Analysis, 2001-2002,2004
#  szafrans@imb-jena.de
#
################################################################################
#
#  DESCRIPTION
#
# - individual description of functions at the beginning of the code blocks
#
################################################################################
#
#  FUNCTIONS, DATA
#
#   @ISA
#
# - housekeeping
#   &new
#
################################################################################

package MainLib::DefaultObjArray;

# includes
use strict;
use MainLib::DefaultObj;

# inheritance
our @ISA;
push @ISA, qw(MainLib::DefaultObj);


################################################################################
# housekeeping
################################################################################


# return class instance
#
# INTERFACE
# - argument 1*: initialisation arguments
# - return val:  reference on object
#
# DESCRIPTION
# - this method new() will call method ini(), provided by the derived class.
#   See class method ini() for detailed description of initialisation parameter
#   convention.
#
sub new {
  my $this = [];
  my ($class,@arg) = @_;
  # this syntax works also for the derived classes, whereas `bless $this;' wouldn't
  bless ($this, ref($class)||$class);
  return $this->ini(@arg);
}


1;
# $Id: DefaultObjArray.pm,v 1.6 2004/11/17 03:34:11 karol Exp $
