################################################################################
#
#  kPerl Dictyostelium ReadWatch Concept
#  Library for Handling 'Clone Library Plate' Data
#
#  copyright (c)
#  Karol Szafranski on behalf of IMB Jena, Genome Analysis, 2000,2002
#  szafrans@imb-jena.de
#
################################################################################
#
#  DESCRIPTION
#
# - individual description of functions at the beginning of the code blocks
#
################################################################################
#
#  FUNCTIONS, DATA
#
#   @EXPORT
#   %_LibParam
#
# - plate data I/O
#   $_LibParam{format}
#   &PlateLoad96
#
################################################################################
#
#  DEBUG, CHANGES, ADDITIONS
#
# - look also for notes in the header of each function block
#
################################################################################

package ReadWatch::Plate;

# includes
use strict; #use warnings;  # OK 2003xxxx

# symbol export
our (@ISA, @EXPORT);
use Exporter;
@ISA = qw(Exporter);
@EXPORT = qw (
  &PlateLoad96
  );

# package-wide constants and variables
my %_LibParam;


################################################################################
# plate data I/O
################################################################################


# format constants
$_LibParam{format} = {
  DefaultSize => 96,
  };


# load probes on 96 plate
#
# INTERFACE
# - argument 1: reference to array of probes
#               data is left unchanged
#
# - options:
#   ...
#
# - return val: array of plates (itself references to 2D hashes)
#
# DESCRIPTION
# - if the last plate cannot be filled completely, the function prefers
#   64-loading of the last plate (odd number of plates) or the last
#   two plates (smooth number of plates).
#
sub PlateLoad96 {
  my ($pProbe, %opt) = @_;
  my ($debug, @probe);
  my (@List96, %Plate96, @plate, $CtPlate);

  # function parameters
  $debug = $opt{-debug};
  (@probe = @$pProbe) or return ();

  # loop over portions of 96 probes
  while (@List96 = splice (@probe, 0, 96)) {

    # prefer 64-loading for incomplete plates
    if (! ($CtPlate % 2) and @List96 == 96 and @probe and @probe <= 32) {
      unshift @probe, splice (@List96, 64, 32);
    }

    # load full 96-well plate
    if (@List96 > 64) {
      %Plate96 = (
        A => [ @List96[ 0..11] ],
        B => [ @List96[12..23] ],
        C => [ @List96[24..35] ],
        D => [ @List96[36..47] ],
        E => [ @List96[48..59] ],
        F => [ @List96[60..71] ],
        G => [ @List96[72..83] ],
        H => [ @List96[84..95] ],
        );
    }

    # load lower two third of 96-well plate
    else {
      %Plate96 = (
        A => [ @List96[ 0.. 7] ],
        B => [ @List96[ 8..15] ],
        C => [ @List96[16..23] ],
        D => [ @List96[24..31] ],
        E => [ @List96[32..39] ],
        F => [ @List96[40..47] ],
        G => [ @List96[48..55] ],
        H => [ @List96[56..63] ],
        );
    }
    
    push @plate, { %Plate96 };
    $CtPlate ++;
  }
  
  # return array of plates
  return @plate;
}


1;
# $Id: Plate.pm,v 1.4 2004/11/09 23:34:13 karol Exp $
