################################################################################
#
#  kPerl Core Library Group
#  Abstract Object Library - Array Architecture
#
#  copyright (c)
#    Institute of Molecular Biotechnology Jena, Dept. Genome Analysis, 2001-2002,2004
#  author
#    Karol Szafranski, karol.szafranski@leibniz-fli.de
#
################################################################################
#
#  DESCRIPTION
#
# - individual description of functions at the beginning of the code blocks
#
################################################################################
#
#  FUNCTIONS, DATA
#
#   @ISA
#
# - housekeeping
#   &new
#
################################################################################

package MainLib::DefaultObjArray;

# includes
use strict;
use MainLib::DefaultObj;

# inheritance
our @ISA;
push @ISA, qw(MainLib::DefaultObj);


################################################################################
# housekeeping
################################################################################


# return class instance
#
# INTERFACE
# - argument 1*: initialization arguments
# - return val:  reference on object
#
# DESCRIPTION
# - this method new() will call method ini(), provided by the derived class.
#   See class method ini() for detailed description of initialization parameter
#   convention.
#
sub new {
  my $this = [];
  my ($class,@arg) = @_;
  # this syntax works also for the derived classes, whereas `bless $this;' wouldn't
  bless ($this, ref($class)||$class);
  return $this->ini(@arg);
}


1;
# $Id: DefaultObjArray.pm,v 1.10 2018/06/05 18:02:56 szafrans Exp $
